var
  V: TValue;
  i: integer;
begin
  V := 42;
  i := V; // Tak nie wolno robi
end;

// -----------------------------------------------------------------------------

var
  V: TValue;
  i: integer;
begin
  V := 42;
  i := V.AsInteger; // Tak mona robi
end.

// -----------------------------------------------------------------------------

// Ten wiersz nie skompiluje si:
// i := V;
// ale ten tak:
i := V.AsInteger;
// a ten te nie
// i  := V.AsString;

// -----------------------------------------------------------------------------

var
  V: TValue;
begin
  V := 42;
  V  := V.Cast<Byte>;
  WriteLn('V jest teraz typu Byte: ', V.ToString);
end.

// -----------------------------------------------------------------------------

if V.IsType<Byte> then
begin
  WriteLn('To prawda, V jest typu Byte');
end else
begin
  WriteLn('Ojej, V nie jest typu Byte');
end;

// -----------------------------------------------------------------------------

type
  TPrzykadowyRekord = record
  LiczbaCakowita: integer;
  Bajty: array[0..5] of Char;
end;

// -----------------------------------------------------------------------------

var
  PR: TPrzykadowyRekord;

{...}

PR.LiczbaCakowita := 99;
PR.Bajty[0] := 'a';
PR.Bajty[1] := 'b';
PR.Bajty[2] := 'c';
PR.Bajty[3] := 'd';
PR.Bajty[4] := 'e';
PR.Bajty[5] := 'f';

// -----------------------------------------------------------------------------

// Mona utworzy wasny typ danych i przerobi go na TValue
TValue.Make(@PR, TypeInfo(TPrzykadowyRekord), V );

// -----------------------------------------------------------------------------

if V.IsType<TPrzykadowyRekord> then
begin
  WriteLn('V jest typu TPrzykadowyRekord');
end else
begin
  WriteLn('V nie jest typu TPrzykadowyRekord');
end;

PR2 := V.AsType<TPrzykadowyRekord>;

WriteLn('PR2.LiczbaCakowita = ', PR2.LiczbaCakowita);
Write('To powinno by pierwszych sze liter alfabetu: ');
for Z in PR2.Bajty do
begin
  Write(Z);
end;
WriteLn;

// -----------------------------------------------------------------------------

TypTymcz := Kontekst.GetType(KlasaDemoRTTI.ClassInfo);
// Pola
WriteLn(TypTymcz.Name, ' zawiera nastpujce pola: ');
for PoleTymcz in TypTymcz.GetFields do
begin
  WriteLn(' ', PoleTymcz.ToString, ' o widocznoci: ',
    GetEnumName(TypeInfo(TMemberVisibility),
      Integer(PoleTymcz.Visibility)));
end;

// -----------------------------------------------------------------------------

// Waciwoci
WriteLn(TypTymcz.Name, ' zawiera nastpujce waciwoci:');
for WaciwoTymcz in TypTymcz.GetProperties do
begin
  WriteLn(' ', WaciwoTymcz.ToString, ' o widocznoci: ',
    GetEnumName(TypeInfo(TMemberVisibility),
      Integer(WaciwoTymcz.Visibility)));
end;

// -----------------------------------------------------------------------------

// Waciwoci indeksowane
WriteLn(TypTymcz.Name, ' zawiera nastpujce waciwoci indeksowane:');
for WaciwoIndTymcz in TypTymcz.GetIndexedProperties do
begin
  WriteLn(' ', WaciwoIndTymcz.ToString, ' o widocznoci: ',
    GetEnumName(TypeInfo(TMemberVisibility),
      Integer(WaciwoIndTymcz.Visibility)));
 end;

// -----------------------------------------------------------------------------

// Metody
WriteLn(TypTymcz.Name, ' zawiera nastpujce metody:');
for MetodaTymcz in TypTymcz.GetDeclaredMethods do
begin
  WriteLn(' ', MetodaTymcz.Name);
  ParametryTymcz := MetodaTymcz.GetParameters;
if Length(ParametryTymcz) > 0 then
begin
  for ParametrTymcz in ParametryTymcz do
  begin
    WriteLn(' ', ParametrTymcz.ToString);
  end;
  end else
  begin
    WriteLn(' ', 'brak parametrw');
  end;
end;

// -----------------------------------------------------------------------------

WriteLn('Odczytywanie i nadawanie wartoci pola prywatnego...');
TypTymcz := Kontekst.GetType(KlasaDemoRTTI.ClassInfo);
PoleTymcz := TypTymcz.GetField('FPolePrywatne');
NowaWarto := 'Nowa warto pola FPolePrywatne zapisana w zamiennej typu TValue';
PoleTymcz.SetValue(KDR, NowaWarto);
WriteLn('Warto t mona odczyta za pomoca RTTI: ',
  PoleTymcz.GetValue(KDR).ToString);

// -----------------------------------------------------------------------------

WriteLn('Odczytywanie i nadawanie wartoci waciwoci...');
WaciwoTymcz := TypTymcz.GetProperty('WaciwoPubliczna');
NowaWarto := 'Nowa warto WaciwoPubliczna';
WaciwoTymcz.SetValue(KDR, NowaWarto);
WriteLn('WaciwoPubliczna ma teraz warto: ', KDR.WaciwoPubliczna);
WriteLn('Warto t mona te odczyta za pomoc RTTI: ',
  WaciwoTymcz.GetValue(KDR).ToString);

// -----------------------------------------------------------------------------

WaciwoIndTymcz := TypTymcz.GetIndexedProperty('WaciwoIndeksowana');
NowaWarto := 'To jest indeks 0';
WaciwoIndTymcz.SetValue(KDR, [0], NowaWarto);
NowaWarto := 'To jest indeks 1';
WaciwoIndTymcz.SetValue(KDR, [1], NowaWarto);
WriteLn('WaciwoIndeksowana[0] odczytana za pomoc RTTI: ',
  WaciwoIndTymcz.GetValue(KDR, [0]).ToString);
WriteLn('WaciwoIndeksowana[1] odczytana bezporednio z instancji: ',
  KDR.WaciwoIndeksowana[1]);

// -----------------------------------------------------------------------------

procedure WywoanieMetodyZaPomocRTTI;
var
  KDR: KlasaDemoRTTI;
  Kontekst: TRttiContext;
  TypTymcz: TRttiType;
  MetodaTymcz: TRttiMethod;
  ParametryTymcz: TArray<TRttiParameter>;
  ParametrTymcz: TRttiParameter;
  TymczWarto: TValue;
  TymczWynik: TValue;
  WartociParametrw: array[0..1] of TValue;
  i: Integer;
begin
  KDR := KlasaDemoRTTI.Create;
  try
    TypTymcz := Kontekst.GetType(KlasaDemoRTTI);
    for MetodaTymcz in TypTymcz.GetDeclaredMethods do
    begin
      // Pominicie konstruktora i analiza tylko metod publicznych
      if (MetodaTymcz.Visibility <> mvPublic) then Continue;
      if MetodaTymcz.IsConstructor then Continue;
      WriteLn('Wywoanie metody o nazwie: ', MetodaTymcz.Name);
      case MetodaTymcz.MethodKind of
        mkProcedure: begin
                       ParametryTymcz := MetodaTymcz.GetParameters;
                       // Znamy parametry...
                       i := 0;

                       case Length(ParametryTymcz) of
                         0: MetodaTymcz.Invoke(KDR, []);
                         1: MetodaTymcz.Invoke(KDR, [0]);
                         2: begin
                              for ParametrTymcz in ParametryTymcz do
                              begin
                                case ParametrTymcz.ParamType.TypeKind of
                                  tkString,
                                  tkUString: TymczWarto :=
                                               'Parametry przekazane przez Invoke';
                                  tkFloat: TymczWarto := 3.14159;
                                  tkInteger: TymczWarto := 0;
                                end;
                                WartociParametrw[i] := TymczWarto;
                                inc(i);
                              end;

                              MetodaTymcz.Invoke(KDR, [WartociParametrw[0],
                                                 WartociParametrw[1]]);
                            end;
                       end;
                     end;
        mkFunction: begin
                      // Pominicie metod odczytujcych waciwoci
                      if not UpperCase(MetodaTymcz.Name).Contains('GET') then
                      begin
                        TymczWynik := MetodaTymcz.Invoke(KDR, []);
                        WriteLn('Wynik wywoania metody ', MetodaTymcz.Name, ': ',
                          TymczWynik.ToString);
                      end;
                    end;
      else
        Continue;
      end;
    end;
  finally
    KDR.Free;
  end;
end;

// -----------------------------------------------------------------------------

var
  Kontekst: TRttiContext;
  TypTymcz: TRttiType;
  TypPorzTymcz: TRTTIOrdinalType;
begin
  // Typ porzdkowy
  TypTymcz := Kontekst.GetType(TypeInfo(Byte));
  if TypTymcz.IsOrdinal then
  begin
    TypPorzTymcz := TypTymcz as TRTTIOrdinalType;
    WriteLn('Minimalna warto dla typu ', TypPorzTymcz.Name, ' wynosi: ',
            TypPorzTymcz.MinValue);
    WriteLn('Maksymalna warto dla typu ', TypPorzTymcz.Name, ' wynosi: ',
            TypPorzTymcz.MaxValue);
  end;
end;

// -----------------------------------------------------------------------------

// Rekord
TypTymcz := Kontekst.GetType(TypeInfo(TRekordDemo));
if TypTymcz.IsRecord then
begin
  RekordTymcz := TypTymcz.AsRecord;
  WriteLn(RekordTymcz.Name, ' zawiera nastepujce metody: ');
  for MetodaTymcz in RekordTymcz.GetMethods do
  begin
    WriteLn(' ', MetodaTymcz.Name);
  end;
  WriteLn('... i pola:');
  for PoleTymcz in RekordTymcz.GetFields do
  begin
    WriteLn(' ', PoleTymcz.Name);
  end;
  WriteLn;
end;

// -----------------------------------------------------------------------------

// Tabele
TypTymcz := Kontekst.GetType(TypeInfo(TTrjwymiarowaTabelaTekstowa));
if TypTymcz.TypeKind = tkArray then
begin
  TabelaTymcz := TypTymcz as TRttiArrayType;
  WriteLn(TabelaTymcz.Name, ' jest to ', TabelaTymcz.DimensionCount,
    '-wymiarowa tabela zawierajca ', TabelaTymcz.TotalElementCount,
    ' elementw typu ', TabelaTymcz.ElementType.Name);
end;

// -----------------------------------------------------------------------------

{$RTTI INHERIT}
TDziecko = class(TRodzic)

// -----------------------------------------------------------------------------

{$RTTI EXPLICIT}
TDziecko = class(TRodzic)
